/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractInput
implements Input {
    static final I18N i18n = Application.getI18n();
    private Map<String, Object> data = new HashMap<String, Object>();
    private static final Object PLACEHOLDER = new Object();
    private Composite parent = null;
    private String name = null;
    private String comment = null;
    private Label commentLabel = null;
    private Control control = null;
    private ArrayList<Listener> listeners = new ArrayList();
    private String validChars = null;
    private String invalidChars = null;
    private boolean mandatory = false;
    private Object oldValue = PLACEHOLDER;
    private boolean inUpdate = false;

    protected Composite getParent() {
        return this.parent;
    }

    public int getStyleBits() {
        return 768;
    }

    @Override
    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
        if (this.commentLabel != null && !this.commentLabel.isDisposed() && this.comment != null) {
            this.commentLabel.setText(this.comment);
            this.commentLabel.redraw();
        }
    }

    @Override
    public final void paint(Composite parent) {
        this.paint(parent, 240);
    }

    @Override
    public final void paint(Composite parent, int width) {
        boolean hasComment = this.comment != null;
        this.parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 2;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 0;
        this.parent.setLayout((Layout)layout);
        GridData g = new GridData(this.getStyleBits());
        this.parent.setLayoutData((Object)g);
        this.control = this.getControl();
        this.applyVerifier(this.control);
        if (this.control.getLayoutData() == null) {
            GridData inputGrid = new GridData(this.getStyleBits());
            inputGrid.widthHint = hasComment ? width / 2 : width;
            inputGrid.horizontalSpan = hasComment ? 1 : 2;
            this.control.setLayoutData((Object)inputGrid);
        }
        if (hasComment) {
            this.commentLabel = GUI.getStyleFactory().createLabel(this.parent, 0);
            this.commentLabel.setText(this.comment);
            this.commentLabel.setForeground(Color.COMMENT.getSWTColor());
            this.commentLabel.setAlignment(16384);
            this.commentLabel.setLayoutData((Object)new GridData(768));
        }
        Listener l = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            l = this.listeners.get(i);
            this.addListener((Widget)this.control, l);
        }
        if (this.control instanceof Composite) {
            Composite c = (Composite)this.control;
            Control[] children = c.getChildren();
            for (int j = 0; j < children.length; ++j) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    l = this.listeners.get(i);
                    this.addListener((Widget)children[j], l);
                }
                this.applyVerifier(children[j]);
            }
        }
        this.update();
    }

    protected void addListener(Widget w, Listener l) {
        w.addListener(13, l);
        w.addListener(15, l);
        w.addListener(16, l);
    }

    private void applyVerifier(Control control) {
        boolean single;
        if (control == null || !(control instanceof Text) && !(control instanceof Combo)) {
            return;
        }
        Listener updateCheck = new Listener(){

            public void handleEvent(Event event) {
                try {
                    AbstractInput.this.update();
                }
                catch (OperationCanceledException operationCanceledException) {
                    // empty catch block
                }
            }
        };
        DelayedListener dl = new DelayedListener(100, updateCheck);
        control.addListener(16, (Listener)dl);
        control.addListener(24, (Listener)dl);
        boolean bl = single = (control.getStyle() & 4) != 0;
        if (single) {
            control.addListener(25, new Listener(){

                public void handleEvent(Event e) {
                    e.text = e.text.replace("\n", "").replace("\r", "");
                }
            });
        }
        if (this.validChars != null && this.validChars.length() > 0) {
            control.addListener(25, new Listener(){

                public void handleEvent(Event e) {
                    char[] chars = e.text.toCharArray();
                    for (int i = 0; i < chars.length; ++i) {
                        if (AbstractInput.this.validChars.indexOf(chars[i]) != -1) continue;
                        e.doit = false;
                        return;
                    }
                }
            });
        }
        if (this.invalidChars != null && this.invalidChars.length() > 0) {
            control.addListener(25, new Listener(){

                public void handleEvent(Event e) {
                    char[] chars = e.text.toCharArray();
                    for (int i = 0; i < chars.length; ++i) {
                        if (AbstractInput.this.invalidChars.indexOf(chars[i]) == -1) continue;
                        e.doit = false;
                        return;
                    }
                }
            });
        }
    }

    public void setValidChars(String chars) {
        this.validChars = chars;
    }

    public void setInvalidChars(String chars) {
        this.invalidChars = chars;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory && Application.getConfig().getMandatoryCheck();
    }

    protected void update() throws OperationCanceledException {
        if (this.inUpdate) {
            throw new OperationCanceledException();
        }
        try {
            this.inUpdate = true;
            if (this.control == null || this.control.isDisposed()) {
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            Object value = this.getValue();
            if (this.isMandatory() && (value == null || "".equals(value.toString()))) {
                this.control.setBackground(Color.MANDATORY_BG.getSWTColor());
                return;
            }
            this.control.setBackground(null);
        }
        finally {
            this.inUpdate = false;
        }
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (mandatory != this.mandatory && this.control != null && !this.control.isDisposed()) {
            this.mandatory = mandatory;
            this.update();
        } else {
            this.mandatory = mandatory;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (this.name != null) {
            Object o = this.getData("jameica.label");
            if (o == null || !(o instanceof Label)) {
                return;
            }
            Label label = (Label)o;
            if (label.isDisposed()) {
                return;
            }
            label.setText(this.name);
        }
    }

    @Override
    public boolean hasChanged() {
        Object newValue = this.getValue();
        try {
            if (this.oldValue == PLACEHOLDER || this.oldValue == newValue) {
                boolean bl = false;
                return bl;
            }
            boolean bl = newValue == null || !newValue.equals(this.oldValue);
            return bl;
        }
        finally {
            this.oldValue = newValue;
        }
    }

    @Override
    public void setData(String key, Object data) {
        this.data.put(key, data);
    }

    @Override
    public Object getData(String key) {
        return this.data.get(key);
    }
}

